define(['modules/notifications/models/notifications-collection'], function(NotificationsCollection) {
    'use strict';

    describe('Notification Collection', function() {
        var collection;

        beforeEach(function() {
            collection = new NotificationsCollection();
        });

        it('has a function to return the total number of unread notifications', function() {
            expect(collection.totalUnread()).toEqual(0);
            collection.add([
                {readFlag: false},
                {readFlag: false},
                {readFlag: false},
            ]);
            expect(collection.totalUnread()).toEqual(3);

            collection.at(1).set('readFlag', true);
            expect(collection.totalUnread()).toEqual(2);

            collection.at(1).set('readFlag', false);
            expect(collection.totalUnread()).toEqual(3);
        });
    });
});
